'use client'

import { useEffect, useRef, useState } from 'react'
import Header from '../../../components/Header'
import MobileHeader from '../../../components/MobileHeader'
import Footer from '../../../components/Footer'
import { useTranslations } from 'next-intl'
import AnimatedText from '../../../components/AnimatedText'
import AnimatedElement from '../../../components/AnimatedElement'

export default function EnvironmentalSustainability() {
  const t = useTranslations('EnvironmentalSustainabilityPage');
  const video1Ref = useRef<HTMLVideoElement>(null)
  const video2Ref = useRef<HTMLVideoElement>(null)
  const [isDesktop, setIsDesktop] = useState(false)

  useEffect(() => {
    const checkScreenSize = () => {
      setIsDesktop(window.innerWidth >= 1024);
    };

    checkScreenSize();
    window.addEventListener('resize', checkScreenSize);

    return () => window.removeEventListener('resize', checkScreenSize);
  }, []);

  useEffect(() => {
    if (video1Ref.current) {
      video1Ref.current.play().catch(() => {
        // Видео не смогло воспроизвестись автоматически
      })
    }
    if (video2Ref.current) {
      video2Ref.current.play().catch(() => {
        // Видео не смогло воспроизвестись автоматически
      })
    }
  }, [])

  return (
    <div className="w-full flex flex-col items-start bg-[#F5F1F0] font-roboto">
      {/* Header */}
      <div className="w-full bg-white">
        <div className="w-full max-w-[1440px] mx-auto">
      {isDesktop ? <Header /> : <MobileHeader />}
        </div>
      </div>
      
      <main className="w-full">
        {/* Main Section */}
        <section className="flex pb-[60px] flex-col justify-center items-center gap-[50px] w-full">
        {/* Panorama Section */}
        <div className="flex flex-col justify-end items-center gap-6 w-full">
          <div 
              className="flex h-[597px] flex-col justify-end items-center gap-6 w-full bg-cover bg-center relative"
            style={{
              backgroundImage: `linear-gradient(180deg, rgba(0, 0, 0, 0.50) 0%, rgba(0, 0, 0, 0.19) 100%), url('/images/Environmental Sustainabilit/335d04b60e2231a113c09c5798236a267262ccf5.jpg')`
            }}
          >
              <div className="flex max-w-[1376px] w-full flex-col items-start gap-6 flex-1 mx-auto p-8">
              <div className="flex flex-col justify-between items-start flex-1 w-full">
                  <AnimatedText
                    as="h1"
                    animation="slideInUp"
                    delay={200}
                    className="w-full text-center text-white text-[40px] font-light leading-[115%] tracking-[-1.2px] font-roboto"
                  >
                  {t('hero_title')}
                  </AnimatedText>
                  <AnimatedText
                    as="h2"
                    animation="slideInUp"
                    delay={400}
                    className="w-full text-white text-2xl font-light leading-[130%] font-roboto"
                  >
                  {t('hero_subtitle')}
                  </AnimatedText>
              </div>
            </div>
          </div>
          
          {/* Description Section */}
            <div className="flex px-8 flex-col justify-end items-center gap-2 w-full">
              <div className="flex w-full max-w-[1376px] mx-auto pl-6 flex-col items-start gap-4 border-l border-[rgba(28,28,28,0.20)]">
                <AnimatedText
                  as="p"
                  animation="slideInUp"
                  delay={600}
                  className="max-w-[1344px] w-full text-[#1C1C1C] text-lg font-light leading-[150%] font-roboto"
                >
                {t('description')}
                </AnimatedText>
            </div>
          </div>
        </div>

        {/* Cards Section */}
        {isDesktop ? (
          <div className="flex max-w-[1376px] w-full justify-center items-start gap-8 mx-auto px-8">
            {/* Card 1 - Landscape Design */}
            <div className="flex flex-col items-start flex-1">
              <AnimatedElement
                animation="slideInLeft"
                delay={200}
                className="flex h-[378px] pr-6 items-start gap-2 w-full relative overflow-hidden"
              >
                <video
                  ref={video1Ref}
                  className="w-full h-full object-cover"
                  autoPlay
                  loop
                  muted
                  playsInline
                >
                  <source src="/images/Environmental Sustainabilit/environmental and sustainability.mp4" type="video/mp4" />
                </video>
              </AnimatedElement>
              <div className="flex pt-6 flex-col items-start gap-4 w-full">
                <AnimatedText
                  as="h3"
                  animation="slideInLeft"
                  delay={400}
                  className="w-full text-[#1C1C1C] text-2xl font-light leading-[130%] font-roboto"
                >
                  {t('card1_title')}
                </AnimatedText>
                <AnimatedText
                  as="p"
                  animation="slideInLeft"
                  delay={500}
                  className="w-full text-[#1C1C1C] text-lg font-light leading-[150%] font-roboto"
                >
                  {t('card1_desc')}
                </AnimatedText>
              </div>
            </div>

            {/* Card 2 - Natural Attractions */}
            <div className="flex flex-col items-start flex-1">
              <AnimatedElement
                animation="slideInRight"
                delay={200}
                className="flex h-[378px] pr-6 items-start gap-2 w-full relative overflow-hidden"
              >
                <video
                  ref={video2Ref}
                  className="w-full h-full object-cover"
                  autoPlay
                  loop
                  muted
                  playsInline
                >
                  <source src="/images/Environmental Sustainabilit/377073919285563396.mp4" type="video/mp4" />
                </video>
              </AnimatedElement>
              <div className="flex pt-6 flex-col items-start gap-4 w-full">
                <AnimatedText
                  as="h3"
                  animation="slideInRight"
                  delay={400}
                  className="w-full text-[#1C1C1C] text-2xl font-light leading-[130%] font-roboto"
                >
                  {t('card2_title')}
                </AnimatedText>
                <AnimatedText
                  as="p"
                  animation="slideInRight"
                  delay={500}
                  className="w-full text-[#1C1C1C] text-lg font-light leading-[150%] font-roboto"
                >
                  {t('card2_desc')}
                </AnimatedText>
              </div>
            </div>
          </div>
        ) : (
          <div className="flex flex-col items-center gap-10 w-full px-3">
            {/* Mobile Card 1 - Landscape Design */}
            <div className="flex flex-col items-start w-full">
              <AnimatedElement
                animation="slideInUp"
                delay={200}
                className="flex h-[351px] items-start gap-2 w-full relative overflow-hidden"
              >
                <video
                  ref={video1Ref}
                  className="w-full h-full object-cover"
                  autoPlay
                  loop
                  muted
                  playsInline
                >
                  <source src="/images/Environmental Sustainabilit/environmental and sustainability.mp4" type="video/mp4" />
                </video>
              </AnimatedElement>
              <div className="flex pt-6 flex-col items-start gap-4 w-full">
                <AnimatedText
                  as="h3"
                  animation="slideInUp"
                  delay={400}
                  className="w-full text-[#1C1C1C] text-2xl font-light leading-[130%] font-roboto"
                >
                  {t('card1_title')}
                </AnimatedText>
                <AnimatedText
                  as="p"
                  animation="slideInUp"
                  delay={500}
                  className="w-full text-[#1C1C1C] text-lg font-light leading-[150%] font-roboto"
                >
                  {t('card1_desc')}
                </AnimatedText>
              </div>
            </div>

            {/* Mobile Card 2 - Natural Attractions */}
            <div className="flex flex-col items-start w-full">
              <AnimatedElement
                animation="slideInUp"
                delay={300}
                className="flex h-[351px] items-start gap-2 w-full relative overflow-hidden"
              >
                <video
                  ref={video2Ref}
                  className="w-full h-full object-cover"
                  autoPlay
                  loop
                  muted
                  playsInline
                >
                  <source src="/images/Environmental Sustainabilit/377073919285563396.mp4" type="video/mp4" />
                </video>
              </AnimatedElement>
              <div className="flex pt-6 flex-col items-start gap-4 w-full">
                <AnimatedText
                  as="h3"
                  animation="slideInUp"
                  delay={600}
                  className="w-full text-[#1C1C1C] text-2xl font-light leading-[130%] font-roboto"
                >
                  {t('card2_title')}
                </AnimatedText>
                <AnimatedText
                  as="p"
                  animation="slideInUp"
                  delay={700}
                  className="w-full text-[#1C1C1C] text-lg font-light leading-[150%] font-roboto"
                >
                  {t('card2_desc')}
                </AnimatedText>
              </div>
            </div>
          </div>
        )}
        </section>
      </main>

      <Footer />
    </div>
  )
} 